<?php

/**
 * @package		Joomla.Administrator
 * @subpackage	Templates.hathor
 * @copyright	Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @since		1.6
 */
// no direct access
defined('_JEXEC') or die;
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');
$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
echo JRoute::_('index.php?option=com_banners&view=clients');
echo JText::_('JSEARCH_FILTER_LABEL');
echo JText::_('JSEARCH_FILTER_LABEL');
echo $this->escape($this->state->get('filter.search'));
echo JText::_('COM_BANNERS_SEARCH_IN_TITLE');
echo JText::_('JSEARCH_FILTER_SUBMIT');
echo JText::_('JSEARCH_FILTER_CLEAR');
echo JText::_('JOPTION_SELECT_PUBLISHED');
echo JText::_('JOPTION_SELECT_PUBLISHED');
echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true);
echo JText::_('JSUBMIT');
echo JText::_('JGLOBAL_CHECK_ALL');
echo JHtml::_('grid.sort', 'COM_BANNERS_HEADING_CLIENT', 'name', $listDirn, $listOrder);
echo JHtml::_('grid.sort', 'COM_BANNERS_HEADING_CONTACT', 'contact', $listDirn, $listOrder);
echo JHtml::_('grid.sort', 'JSTATUS', 'state', $listDirn, $listOrder);
echo JHtml::_('grid.sort', 'COM_BANNERS_HEADING_ACTIVE', 'nbanners', $listDirn, $listOrder);
echo JText::_('COM_BANNERS_HEADING_METAKEYWORDS');
echo JText::_('COM_BANNERS_HEADING_PURCHASETYPE');
echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'id', $listDirn, $listOrder);
?>
				</th>
			</tr>
		</thead>

		<tbody>
		<?php 
foreach ($this->items as $i => $item) {
    $ordering = $listOrder == 'ordering';
    $canCreate = $user->authorise('core.create', 'com_banners');
    $canEdit = $user->authorise('core.edit', 'com_banners');
    $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $user->get('id') || $item->checked_out == 0;
    $canChange = $user->authorise('core.edit.state', 'com_banners') && $canCheckin;
    ?>
			<tr class="row<?php 
    echo $i % 2;
    ?>">
				<td class="center">
					<?php 
    echo JHtml::_('grid.id', $i, $item->id);
    ?>
				</td>
				<td>
					<?php 
    if ($item->checked_out) {
        ?>
						<?php 
        echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'clients.', $canCheckin);
        ?>
					<?php 
    }
    ?>
					<?php 
    if ($canEdit) {
        ?>
						<a href="<?php 
        echo JRoute::_('index.php?option=com_banners&task=client.edit&id=' . (int) $item->id);
        ?>">
							<?php 
        echo $this->escape($item->name);
        ?></a>
					<?php 
    } else {
        ?>
							<?php 
        echo $this->escape($item->name);
        ?>
					<?php 
    }
    ?>
				</td>
				<td class="center">
					<?php 
    echo $item->contact;
    ?>
				</td>
				<td class="center">
					<?php 
    echo JHtml::_('jgrid.published', $item->state, $i, 'clients.', $canChange);
    ?>
				</td>
				<td class="center">
					<?php 
    echo $item->nbanners;
    ?>
				</td>
				<td>
					<?php 
    echo $item->metakey;
    ?>
				</td>
				<td class="center">
					<?php 
    if ($item->purchase_type < 0) {
        ?>
						<?php 
        echo JText::sprintf('COM_BANNERS_DEFAULT', JText::_('COM_BANNERS_FIELD_VALUE_' . $this->state->params->get('purchase_type')));
        ?>
					<?php 
    } else {
        ?>
						<?php 
        echo JText::_('COM_BANNERS_FIELD_VALUE_' . $item->purchase_type);
        ?>
					<?php 
    }
    ?>
				</td>
				<td class="center">
					<?php 
    echo $item->id;
    ?>
				</td>
			</tr>
			<?php 
}
?>
		</tbody>
	</table>

	<?php 
echo $this->pagination->getListFooter();
?>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php 
echo $listOrder;
?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php 
echo $listDirn;
?>" />
	<?php 
echo JHtml::_('form.token');
?>
</form>
