<?php

/**
 * @package		Joomla.Site
 * @subpackage	mod_weblinks
 * @copyright	Copyright (C) 2005 - 2009 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
echo JText::_('TPL_OT_SELECT_LINK');
foreach ($list as $item) {
    ?>
		<li role="presentation">
			<?php 
    $link = $item->link;
    switch ($params->get('target', 3)) {
        case 1:
            // open in a new window
            echo '<a href="' . $link . '" target="_blank" rel="' . $params->get('follow', 'no follow') . '">' . htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8') . '</a>';
            break;
        case 2:
            // open in a popup window
            echo "<a href=\"#\" onclick=\"window.open('" . $link . "', '', 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=780,height=550'); return false\">" . htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8') . '</a>';
            break;
        default:
            // open in parent window
            echo '<a href="' . $link . '" rel="' . $params->get('follow', 'no follow') . '">' . htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8') . '</a>';
            break;
    }
    ?>
			<?php 
    if ($params->get('description', 0)) {
        ?>
				<?php 
        echo nl2br($item->description);
        ?>
			<?php 
    }
    ?>

			<?php 
    if ($params->get('hits', 0)) {
        ?>
				<?php 
        echo '(' . $item->hits . ' ' . JText::_('MOD_WEBLINKS_HITS') . ')';
        ?>
			<?php 
    }
    ?>
		</li>
	<?php 
}