<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_finder
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$lang = JFactory::getLanguage();
JText::script('COM_FINDER_MAPS_CONFIRM_DELETE_PROMPT');
echo JRoute::_('index.php?option=com_finder&view=maps');
echo JText::sprintf('COM_FINDER_SEARCH_LABEL', JText::_('COM_FINDER_MAPS'));
echo $this->escape($this->state->get('filter.search'));
echo JText::_('COM_FINDER_FILTER_SEARCH_DESCRIPTION');
echo JText::_('JSEARCH_FILTER_SUBMIT');
echo JText::_('JSEARCH_FILTER_CLEAR');
echo JHtml::_('select.options', JHtml::_('finder.mapslist'), 'value', 'text', $this->state->get('filter.branch'));
echo JText::_('COM_FINDER_INDEX_FILTER_BY_STATE');
echo JHtml::_('select.options', JHtml::_('finder.statelist'), 'value', 'text', $this->state->get('filter.state'));
?>
			</select>
		</div>
	</fieldset>
	<div class="clr"> </div>

	<table class="adminlist" style="clear: both;">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" title="<?php 
echo JText::_('JGLOBAL_CHECK_ALL');
?>" onclick="Joomla.checkAll(this)" />
				</th>
				<th class="nowrap">
					<?php 
echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder);
?>
				</th>
				<th class="nowrap" width="10%">
					<?php 
echo JHtml::_('grid.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder);
?>
				</th>
			</tr>
		</thead>
		<tbody>
			<?php 
if (count($this->items) == 0) {
    ?>
			<tr class="row0">
				<td class="center" colspan="5">
					<?php 
    echo JText::_('COM_FINDER_MAPS_NO_CONTENT');
    ?>
				</td>
			</tr>
			<?php 
}
?>
			<?php 
if ($this->state->get('filter.branch') != 1) {
    ?>
			<tr class="row1">
				<td colspan="5" class="center">
					<a href="#" onclick="document.id('filter_branch').value='1';document.adminForm.submit();">
						<?php 
    echo JText::_('COM_FINDER_MAPS_RETURN_TO_BRANCHES');
    ?></a>
				</td>
			</tr>
			<?php 
}
?>

			<?php 
$canChange = JFactory::getUser()->authorise('core.manage', 'com_finder');
?>
			<?php 
foreach ($this->items as $i => $item) {
    ?>

			<tr class="row<?php 
    echo $i % 2;
    ?>">
				<td class="center">
					<?php 
    echo JHtml::_('grid.id', $i, $item->id);
    ?>
				</td>
				<td>
					<?php 
    $key = FinderHelperLanguage::branchSingular($item->title);
    $title = $lang->hasKey($key) ? JText::_($key) : $item->title;
    ?>
					<?php 
    if ($this->state->get('filter.branch') == 1 && $item->num_children) {
        ?>
						<a href="#" onclick="document.id('filter_branch').value='<?php 
        echo (int) $item->id;
        ?>';document.adminForm.submit();" title="<?php 
        echo JText::_('COM_FINDER_MAPS_BRANCH_LINK');
        ?>">
							<?php 
        echo $this->escape($title);
        ?></a>
					<?php 
    } else {
        ?>
						<?php 
        echo $this->escape($title == '*' ? JText::_('JALL_LANGUAGE') : $title);
        ?>
					<?php 
    }
    ?>
					<?php 
    if ($item->num_children > 0) {
        ?>
						<small>(<?php 
        echo $item->num_children;
        ?>)</small>
					<?php 
    } elseif ($item->num_nodes > 0) {
        ?>
						<small>(<?php 
        echo $item->num_nodes;
        ?>)</small>
					<?php 
    }
    ?>
					<?php 
    if ($this->escape(trim($title, '**')) == 'Language' && JLanguageMultilang::isEnabled()) {
        ?>
						<strong><?php 
        echo JText::_('COM_FINDER_MAPS_MULTILANG');
        ?></strong>
					<?php 
    }
    ?>
				</td>
				<td class="center nowrap">
					<?php 
    echo JHtml::_('jgrid.published', $item->state, $i, 'maps.', $canChange, 'cb');
    ?>
				</td>
			</tr>
			<?php 
}
?>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="9" class="nowrap">
					<?php 
echo $this->pagination->getListFooter();
?>
				</td>
			</tr>
		</tfoot>
	</table>

	<input type="hidden" name="task" value="display" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php 
echo $listOrder;
?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php 
echo $listDirn;
?>" />
	<?php 
echo JHtml::_('form.token');
?>
</form>
