<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_menus
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
// Load the tooltip behavior.
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');
$uri = JFactory::getUri();
$return = base64_encode($uri);
$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$modMenuId = (int) $this->get('ModMenuId');
echo JText::_('COM_MENUS_MENU_CONFIRM_DELETE', true);
echo JRoute::_('index.php?option=com_menus&view=menus');
echo JText::_('JGLOBAL_CHECK_ALL');
echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder);
echo JText::_('COM_MENUS_HEADING_NUMBER_MENU_ITEMS');
echo JText::_('COM_MENUS_HEADING_LINKED_MODULES');
echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder);
echo JText::_('COM_MENUS_HEADING_PUBLISHED_ITEMS');
echo JText::_('COM_MENUS_HEADING_UNPUBLISHED_ITEMS');
echo JText::_('COM_MENUS_HEADING_TRASHED_ITEMS');
echo $this->pagination->getListFooter();
foreach ($this->items as $i => $item) {
    $canCreate = $user->authorise('core.create', 'com_menus');
    $canEdit = $user->authorise('core.edit', 'com_menus');
    $canChange = $user->authorise('core.edit.state', 'com_menus');
    ?>
			<tr class="row<?php 
    echo $i % 2;
    ?>">
				<td class="center">
					<?php 
    echo JHtml::_('grid.id', $i, $item->id);
    ?>
				</td>
				<td>
					<a href="<?php 
    echo JRoute::_('index.php?option=com_menus&view=items&menutype=' . $item->menutype);
    ?> ">
						<?php 
    echo $this->escape($item->title);
    ?></a>
					<p class="smallsub">(<span><?php 
    echo JText::_('COM_MENUS_MENU_MENUTYPE_LABEL');
    ?></span>
						<?php 
    if ($canEdit) {
        ?>
							<?php 
        echo '<a href="' . JRoute::_('index.php?option=com_menus&task=menu.edit&id=' . $item->id) . ' title=' . $this->escape($item->description) . '">' . $this->escape($item->menutype) . '</a>';
        ?>)
						<?php 
    } else {
        ?>
							<?php 
        echo $this->escape($item->menutype);
        ?>)
						<?php 
    }
    ?>
					</p>
				</td>
				<td class="center btns">
					<a href="<?php 
    echo JRoute::_('index.php?option=com_menus&view=items&menutype=' . $item->menutype . '&filter_published=1');
    ?>">
						<?php 
    echo $item->count_published;
    ?></a>
				</td>
				<td class="center btns">
					<a href="<?php 
    echo JRoute::_('index.php?option=com_menus&view=items&menutype=' . $item->menutype . '&filter_published=0');
    ?>">
						<?php 
    echo $item->count_unpublished;
    ?></a>
				</td>
				<td class="center btns">
					<a href="<?php 
    echo JRoute::_('index.php?option=com_menus&view=items&menutype=' . $item->menutype . '&filter_published=-2');
    ?>">
						<?php 
    echo $item->count_trashed;
    ?></a>
				</td>
				<td class="left">
					<?php 
    if (isset($this->modules[$item->menutype])) {
        ?>
					<ul>
						<?php 
        foreach ($this->modules[$item->menutype] as &$module) {
            ?>
						<li>
							<?php 
            if ($canEdit) {
                ?>
								<a class="modal" href="<?php 
                echo JRoute::_('index.php?option=com_modules&task=module.edit&id=' . $module->id . '&return=' . $return . '&tmpl=component&layout=modal');
                ?>" rel="{handler: 'iframe', size: {x: 1024, y: 450}, onClose: function() {window.location.reload()}}"  title="<?php 
                echo JText::_('COM_MENUS_EDIT_MODULE_SETTINGS');
                ?>">
								<?php 
                echo JText::sprintf('COM_MENUS_MODULE_ACCESS_POSITION', $this->escape($module->title), $this->escape($module->access_title), $this->escape($module->position));
                ?></a>
							<?php 
            } else {
                ?>
								<?php 
                echo JText::sprintf('COM_MENUS_MODULE_ACCESS_POSITION', $this->escape($module->title), $this->escape($module->access_title), $this->escape($module->position));
                ?>
							<?php 
            }
            ?>
						</li>
						<?php 
        }
        ?>
					</ul>
					<?php 
    } elseif ($modMenuId) {
        ?>
					<a href="<?php 
        echo JRoute::_('index.php?option=com_modules&task=module.add&eid=' . $modMenuId . '&params[menutype]=' . $item->menutype);
        ?>">
						<?php 
        echo JText::_('COM_MENUS_ADD_MENU_MODULE');
        ?></a>
					<?php 
    }
    ?>
				</td>
				<td class="center">
					<?php 
    echo $item->id;
    ?>
				</td>
			</tr>
			<?php 
}
echo $listOrder;
echo $listDirn;
echo JHtml::_('form.token');