<?php

/**
 * @package		Joomla.Administrator
 * @subpackage	com_modules
 * @copyright	Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
// no direct access
defined('_JEXEC') or die;
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
$function = JRequest::getCmd('function', 'jSelectPosition');
$lang = JFactory::getLanguage();
$ordering = $this->escape($this->state->get('list.ordering'));
$direction = $this->escape($this->state->get('list.direction'));
$clientId = $this->state->get('filter.client_id');
$state = $this->state->get('filter.state');
$template = $this->state->get('filter.template');
$type = $this->state->get('filter.type');
echo JRoute::_('index.php?option=com_modules&view=positions&layout=modal&tmpl=component&function=' . $function . '&client_id=' . $clientId);
echo JText::_('JSearch_Filter_Label');
echo $this->escape($this->state->get('filter.search'));
echo JText::_('COM_MODULES_FILTER_SEARCH_DESC');
echo JText::_('JSEARCH_FILTER_SUBMIT');
echo JText::_('JSEARCH_FILTER_CLEAR');
echo JText::_('JOPTION_SELECT_PUBLISHED');
echo JHtml::_('select.options', JHtml::_('modules.templateStates'), 'value', 'text', $state, true);
echo JText::_('COM_MODULES_OPTION_SELECT_TYPE');
echo JHtml::_('select.options', JHtml::_('modules.types'), 'value', 'text', $type, true);
echo JText::_('JOPTION_SELECT_TEMPLATE');
echo JHtml::_('select.options', JHtml::_('modules.templates', $clientId), 'value', 'text', $template, true);
?>
			</select>
		</div>
	</fieldset>

	<table class="adminlist">
		<thead>
			<tr>
				<th class="title" width="20%">
					<?php 
echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'value', $direction, $ordering);
?>
				</th>
				<th>
					<?php 
echo JHtml::_('grid.sort', 'COM_MODULES_HEADING_TEMPLATES', 'templates', $direction, $ordering);
?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="15">
					<?php 
echo $this->pagination->getListFooter();
?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php 
$i = 1;
foreach ($this->items as $value => $templates) {
    ?>
			<tr class="row<?php 
    echo $i = 1 - $i;
    ?>">
				<td>
					<a class="pointer" onclick="if (window.parent) window.parent.<?php 
    echo $function;
    ?>('<?php 
    echo $value;
    ?>');"><?php 
    echo $this->escape($value);
    ?></a>
				</td>
				<td>
					<?php 
    if (!empty($templates)) {
        ?>
					<a class="pointer" onclick="if (window.parent) window.parent.<?php 
        echo $function;
        ?>('<?php 
        echo $value;
        ?>');">
						<ul>
						<?php 
        foreach ($templates as $template => $label) {
            ?>
							<li><?php 
            echo $lang->hasKey($label) ? JText::sprintf('COM_MODULES_MODULE_TEMPLATE_POSITION', JText::_($template), JText::_($label)) : JText::_($template);
            ?></li>
						<?php 
        }
        ?>
						</ul>
					</a>
					<?php 
    }
    ?>
				</td>
			</tr>
			<?php 
}
?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php 
echo $ordering;
?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php 
echo $direction;
?>" />
		<?php 
echo JHtml::_('form.token');
?>
	</div>
</form>
